/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.AdaptedRemoteWatcher;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.RemoteWatchable;
import ibm.nways.jdm.RemoteWatcherAdapter;
import ibm.nways.jdm.StatusData;
import ibm.nways.jdm.StatusImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.Watcher;

public class StatusProxy
extends StatusImpl
implements AdaptedRemoteWatcher {
    private RemoteStatus remoteStatus;
    private RemoteWatcherAdapter watcherAdapter;

    public StatusProxy(RemoteStatus remoteStatus) {
        this.remoteStatus = remoteStatus;
        try {
            this.watcherAdapter = new RemoteWatcherAdapter(this);
            StatusData statusData = remoteStatus.getStatusData();
            this.setStatusType(statusData.getStatusType(), statusData.getExplanation(), true);
            this.setName(statusData.getName());
            this.setCritical(statusData.isCritical());
            remoteStatus.addWatcher(this.watcherAdapter);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void update(RemoteWatchable remoteWatchable, Object object) {
        if (object instanceof StatusData) {
            StatusData statusData = (StatusData)object;
            this.setStatusType(statusData.getStatusType(), statusData.getExplanation(), true);
            this.setCritical(statusData.isCritical());
        }
    }

    public StatusType check() {
        try {
            StatusData statusData = this.remoteStatus.getStatusData();
            this.setStatusType(statusData.getStatusType(), statusData.getExplanation(), true);
            this.setCritical(statusData.isCritical());
            this.remoteStatus.check();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.getStatusType();
    }

    protected RemoteStatus getRemoteStatus() {
        return this.remoteStatus;
    }

    public synchronized void addWatcher(Watcher watcher) {
        super.addWatcher(watcher);
    }

    public synchronized void deleteWatcher(Watcher watcher) {
        super.deleteWatcher(watcher);
    }

    public void deleteWatchers() {
        super.deleteWatchers();
    }

    public void dispose() {
        if (this.remoteStatus != null && this.watcherAdapter != null) {
            try {
                this.remoteStatus.deleteWatcher(this.watcherAdapter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.remoteStatus = null;
            this.watcherAdapter = null;
        }
    }
}

